;;-*- Mode:Common-Lisp; Package:MACTOOLBOX; Base:10; Fonts:(COURIER medfnb Medfnb) -*-

;1;; For the puposes of the Texas Instruments/ ExperTelligence Contract, this*
;1;; software is in TBI Category "A".*

;1/*                                                                       */*
;1/*                      RESTRICTED RIGHTS LEGEND                         */*
;1/*                                                                       */*
;1/* Use, duplication, or disclosure by the Government is subject to       */*
;1/* restrictions as set forth in subdivision (c)(1)(ii) of the Rights in  */*
;1/* Technical Data and Computer Software clause at 52.227-7013.           */*
;1/*                                                                       */*
;1/*                    TEXAS INSTRUMENTS INCORPORATED.                    */*
;1/*                            P.O. BOX 2909                              */*
;1/*                         AUSTIN, TEXAS 78769                           */*
;1/*                              MS 2151                                  */*
;1/*                                                                       */*
;1/*  Copyright (C) 1988, 1987, Texas Instruments Incorporated.            */*
;1/*  All rights reserved.                                                 */*
;1/*                                                                       */*


;1;;                              Toolbox-interface Qix. *
;1;;*
;1;; This is a version of the Explorer program Qix that has been modified to run*
;1;; through the toolbox interface instead of the Explorer window system. The main*
;1;; modification to qix itself was removing the calls to %draw-line and adding calls*
;1;; to the appropriate QuickDrawing functions. This code also uses the menu bar and*
;1;; handles events.*
;1;;*
;1;; To compile and run this program:*
;1;;
;;; 1) Ensure that the Color-Qix application is under a :microExp folder in your system.
;;;    If it is not present you can create it by using MPW to make the color-qix
;;;    application in :microexp:macsys:toolbox-interface:sample-applications:.
;;; 2) Compile this buffer.*
;1;; 3) Launch the application by:*
;1;;    a) Double clicking on the icon for color-qix.  or*
;1;;    b) executing the form (launch-mac-application 'color-qix)*
;1;; 4) Quit color-qix by selecting the quit entry on the file menu or clicking in the go-away box.*
;1;;*
;1;; Notes:*


;1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;*
;1;;*
;1;;  Variable definitions*
;1;;*
;1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;*

(defvar qix-list nil)
(defvar qix-list-length nil)
(defvar *AppleMenu* nil)
(defvar *FileMenu* nil)
(defvar *ColorMenu* nil)
(defvar *ct* nil)
(defvar *restart* nil)
(defvar *done* nil)
(defvar *event* nil)
(defvar *screenrect* nil)
(defvar *maxrect* nil)
(defvar *event-mask* -1 "2The event mask used by event-handler.*")
(defvar *current-color* nil)


;1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;*
;1;;*
;1;;  Color qix definition*
;1;;*
;1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;*


(define-mac-application color-qix (&optional length)
			(:lisp-function 'tb:tb-qix
					:server-name "color-qix"))

;1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;*
;1;;*
;1;; Initialization*
;1;;*
;1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;*

(defun InitilizeVars (&aux gp ch)
  (setq *restart* nil)
  (setq *done* nil)
  (setq *event* (make-instance 'tb:eventRecord))
  (!flushevents -1 0)
  (setq *current-color*  (make-instance 'tb:rgbcolor))
  
  ;1; Find the screenbytes.bounds by getting the grafport of the entire Mac screen*
  ;1; and asking for its portrect then set the left & top to below menubar*
  (setq gp (make-instance 'tb:cgrafport))   
  (setf gp (GetPort))
  (send gp :portrecttop 23)             
  (send gp :portrectleft 3)    
  (setq *screenrect* (make-instance 'rect))
  (send *screenrect* :set (send gp :portrect))
  
  (setq *maxrect* (make-instance 'rect))
  (send *maxrect* :set-left 100)		       ;1minimum horizontal on a window*
  (send *maxrect* :set-top 40)			       ;1minimum vertical on a window*
  (send *maxrect* :set-right (send gp :portrectright)) ;1max horiz*
  (send *maxrect* :set-bottom (send gp :portrectbottom))       ;1max vert*
  (setq ch (getresource "wctb" 20))
  (setq *ct* (make-instance-no-init 'tb:winctab))
  (send *ct* :set-handle (send ch :handle)))


;1;Makes a menu*
(defun menu-create (ID title data &aux newMenu)
  (setq newMenu (make-instance 'tb:menuinfo))
  (send newmenu :set-handle (send (!NewMenu ID title) :handle))
  (!AppendMenu newMenu data)
  (!InsertMenu newMenu 0)
  newMenu)

;1;This sets up the menubar for Shell application.*
(defun setupmenubar ()
  
  (!ClearMenuBar)

  ;1; Create the Apple menu and add the desk Accessories to it.*
  (setq *AppleMenu* (Menu-Create 10 (string (character 20)) "About Qix...;(-"))
  (!AddResMenu *AppleMenu* "DRVR")

  ;1; Create the file menu.*
  (setq *FileMenu* (Menu-Create 13 "File" "Quit Qix"))

  ;1; Create the color menu*
  (setq *ColorMenu* (Menu-Create 15 "Color" "Content;Frame;Text;Hilite;Title;Line"))
  
  (!DrawMenuBar))


;1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;*
;1;;*
;1;; Event Handling*
;1;;*
;1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;*


(defun event-handler ()
  (when (!WaitNextEvent *event-mask* *event* 0 nilRgn)
    (let ((what (send *event* :what)))
      (cond
	;1; Mouse down *
	((= what 1)
	 (mousedownhandler))
	
	;1; Mouse up*
	((= what 2) nil)
	
	;1; Key down*
	((= what 3)
	 (!SysBeep 1))
	
	;1; Key up*
	((= what 4) nil)
	
	;1; AutoKey*
	((= what 5) nil)
	
	;1; Update*
	((= what 6)
	 ;1; Since we are drawing directly into the window just clear it and start over.*
	 (let ((window (make-instance-no-init 'window)))

	   ;1; This is a crock. We need to be able to pass an int or mac-pointer as a window also.*
	   (send window :eval-inside-yourself `(setf pointer (send ,*event* :message)))
	   
	   (!BeginUpdate window)
	   (!eraserect  (send window :portrect))
	   (setf *restart* t)
	   (!EndUpdate window)))
	
	;1; Disk Insertion*
	((= what 7) nil)
	
	;1; Activate*
	((= what 8) nil)
	
	;1; Network*
	((= what 10) nil)
	
	;1; ioDriver*
	((= what 11) nil)))))

;1; When a mouse click occurs*
(defun mouseDownHandler (&aux partcode win theH theV)

  ;1; Find out what part of the window the user clicked in.*
  (setf (values partcode win) (FindWindow *event*))
  
  (cond 

    ;1; NULL event *
    ((= partcode 0) nil)
    
    ;1; In MenuBar?*			1      *
    ((= partcode 1)
     (inMenuBarHandler *event*))
    
    ;1; In SystemWindow?  *
    ((= partcode 2)
     (!SystemClick *event* Win))
    
    ;1; In Content Region of Window?*	1       *
    ((= partcode 3) nil)
    
    ;1; In Drag Region of Window?*
    ((= partcode 4)
     (!DragWindow Win *event* *screenrect*)) 
    
    ;1; In Grow Region of Window?*
    ((= partcode 5)
     (multiple-value-setq (theV theH) 
       (!GrowWindow Win *event* *maxrect*))
     
     (when (/= 0 theV theH)
       (!SizeWindow Win theH theV t)
       (setq *restart* t)))

    ;1; In GoAway Region of Window?             *
    ((= partcode 6)
     (if (!TrackGoAway win *event*)
	 (setq *done* t)))
    
    ;1; In the ZoomBox?*	1 *
    ((or (= partcode 7)
	 (= partcode 8))
     
     (!TrackBox win *event* partcode)
     (!SetPort win)
     (!ZoomWindow win partcode t)
     (setq *restart* t))
    
    ;1;beep otherwise*	1 *
    (t (!sysbeep 1)))			       
  )

;1;Dispatches to the correct menu handler*
(defun inMenuBarHandler (mousePosition &aux menuID itemID)
  
  ;1;Get the menu and item selection*
  (setf (values menuID itemID) (!MenuSelect mousePosition))
  
  (!HiLiteMenu 0)
  
  (cond
    
    ;1; Apple Menu?*
    ((= menuID 10)				       
     (AppleMenuHandler itemID))

    ;1; File Menu?*
    ((= menuID 13)
     (FileMenuHandler itemID))

    ;1; Option menu?*
    ((= menuID 15)
     (OptionMenuHandler itemID))))

(defun FileMenuHandler (itemID)
  (cond
    ;1; Quit?*
    ((= itemID 1)
     (send (!frontwindow) :dispose)
     (setq *done* t))))

(defun OptionMenuHandler (itemID)
  (cond ((= itemID 6)
	 (wheel))
	(t (otherwheel (- itemid 1)))))

(defun AppleMenuHandler (itemID &aux accRefNum accName)
  
  (cond
    ;1; About me?*
    ((= itemID 1)
     (display-about-me-window))

    ;1; Desk accessory?*
    ((>= itemID 3)

     ;1; Get the name.*
     (setf accName (GetItem *AppleMenu* itemID))

     ;1; Run it.*
     (setq accRefNum (!OpenDeskAcc accName)))))

;1; Not implemented yet.*
(defun display-about-me-window ()
  (!SysBeep 1))


;1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;*
;1;;*
;1;;  Color wheel*
;1;;*
;1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;*


(defun otherwheel (id &aux (out (make-instance 'tb:rgbcolor))
		   (in (make-instance 'tb:rgbcolor))
		   (wh (point 'new)))
  (cond ((= id 0)
	 (send in :red (send *ct* :content.red))
	 (send in :green (send *ct* :content.green))
	 (send in :blue (send *ct* :content.blue)))
	((= id 1)
	 (send in :red (send *ct* :frame.red))
	 (send in :green (send *ct* :frame.green))
	 (send in :blue (send *ct* :frame.blue)))	 
	((= id 2)
	 (send in :red (send *ct* :text.red))
	 (send in :green (send *ct* :text.green))
	 (send in :blue (send *ct* :text.blue)))	 
 	((= id 3)
	 (send in :red (send *ct* :hilite.red))
	 (send in :green (send *ct* :hilite.green))
	 (send in :blue (send *ct* :hilite.blue)))	 
 	((= id 4)
	 (send in :red (send *ct* :titlebar.red))
	 (send in :green (send *ct* :titlebar.green))
	 (send in :blue (send *ct* :titlebar.blue)))
	)
  
  (cond ((!GetColor wh "Pick" in out)
	 (cond ((= id 0)
		(send *ct* :content.value 0)
		(send *ct* :content.red (send out :red))
		(send *ct* :content.green (send out :green))
		(send *ct* :content.blue (send out :blue)))
	       ((= id 1)
		(send *ct* :frame.value 1)
		(send *ct* :frame.red (send out :red))
		(send *ct* :frame.green (send out :green))
		(send *ct* :frame.blue (send out :blue)))
	       ((= id 2)
		(send *ct* :text.value 2)
		(send *ct* :text.red (send out :red))
		(send *ct* :text.green (send out :green))
		(send *ct* :text.blue (send out :blue)))
	       ((= id 3)
		(send *ct* :hilite.value 3)
		(send *ct* :hilite.red (send out :red))
		(send *ct* :hilite.green (send out :green))
		(send *ct* :hilite.blue (send out :blue)))
	       ((= id 4)
		(send *ct* :titlebar.value 4)
		(send *ct* :titlebar.red (send out :red))
		(send *ct* :titlebar.green (send out :green))
		(send *ct* :titlebar.blue (send out :blue)))
	       )
	 (!SetWinColor (!frontwindow) *ct*)
	 (!Setport (!FrontWindow)))
	)
  (setq *restart* t)
  )


(defun wheel (&aux (out (make-instance 'tb:rgbcolor))
	      (wh (point 'new))
	      h)
  (cond ((!GetColor wh "Pick" *current-color* out)
	 (!setport (!frontwindow))
	 (setq *current-color* out)
	 (setq h (!NewPixPat))
	 (!makergbPat h out)
	 (!PenPixPat h)
	 ))
  (setq *restart* t))


;1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;*
;1;;*
;1;;  Qix itself*
;1;;*
;1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;*

(defun tb-qix (&optional (length 100) 
	       &aux
	       (tmp-rect (send (tb:rect 'tb:new *screen-rect*) :inset 10 50))
	       (window (make-instance 'tb:window :boundsrect tmp-rect
				      :title "ExperTelligence QIX"))
	       (times-n NIL)
	       h)
  "2Non-consing QIX.*"

  ;1; Toolbox setup code*
  (InitilizeVars)				       ;1 Initialize Global Variables*
  (SetUpMenuBar)				       ;1 Set up our menu bar*
  (!SetWinColor window *ct*)
  (!setport window)
  (!PenMode patxor)
  (setq h (!NewPixPat))  
  (!makergbpat h *current-color*)
  (!pensize 1 1)

  (prog ()
     restart
	(!eraserect  (send (!frontwindow) :portrect))
	
	(let* ((list (if (and qix-list (<= (1+ length) qix-list-length))
			 qix-list
			 (progn
			   (setq qix-list-length length
				 qix-list (make-list (1+ qix-list-length)))
			   ;1; Make history a circular list.*
			   (si:%p-store-cdr-code (cdr (nthcdr (1- length) qix-list)) cdr-error)
			   (si:%p-store-cdr-code (nthcdr (1- length) qix-list) cdr-normal)
			   (rplacd (nthcdr (1- length) qix-list) qix-list)
			   (loop repeat length
				 for h =(nthcdr (1- length) qix-list) then (cdr h)
				 do (setf (car h) (make-list 4)))
			   qix-list)))	       
	       (history (nthcdr (1- length) list))
	       (xlim (send window :width))
	       (ylim (send window :height)))
	  
	  (loop with x1 = (random xlim)
		and y1 = (random ylim)
		and x2 = (random xlim)
		and y2 = (random ylim)
		and dx1 = 5
		and dy1 = 12
		and dx2 = 12
		and dy2 = 5
		with tem and tem1 = 0
		until (if times-n (= (setf times-n (1- times-n)) 0) NIL)
		when (caar history)
		do   
		
		;1; QuickDraw commands*
		(tb:!moveto (first (car history)) (second (car history)))
		(tb:!lineto (third (car history)) (fourth (car history)))
		
		do
		(WHEN (ZEROP (MOD (INCF tem1) 50))
		  (PROCESS-ALLOW-SCHEDULE)
		  (event-handler))
		(if *done* (return-from tb-qix))
		(cond (*restart*
		       (setq *restart* nil)
		       (go restart)))
		
		(setf (first (car history)) x1)
		(setf (second (car history)) y1)
		(setf (third (car history)) x2)
		(setf (fourth (car history)) y2)
		(setf history (cdr history))
		
		;1; QuickDraw Commands*
		(Tb:!moveto x1 y1)
		(tb:!lineto x2 y2)
		
		(setf dx1 (1- (+ dx1 (random 3)))
		      dy1 (1- (+ dy1 (random 3)))
		      dx2 (1- (+ dx2 (random 3)))
		      dy2 (1- (+ dy2 (random 3))))
		(cond ((> dx1 12) (setf dx1 12))
		      ((< dx1 -12) (setf dx1 -12)))
		(cond ((> dy1 12) (setf dy1 12))
		      ((< dy1 -12) (setf dy1 -12)))
		(cond ((> dx2 12) (setf dx2 12))	
		      ((< dx2 -12) (setf dx2 -12)))
		(cond ((> dy2 12) (setf dy2 12))
		      ((< dy2 -12) (setf dy2 -12)))
		(cond ((or (>= (setf tem (+ x1 dx1)) xlim)
			   (minusp tem))
		       (setf dx1 (- dx1))))
		(cond ((or (>= (setf tem (+ x2 dx2)) xlim)
			   (minusp tem))
		       (setf dx2 (- dx2))))
		(cond ((or (>= (setf tem (+ y1 dy1)) ylim)
			   (minusp tem))
		       (setf dy1 (- dy1))))
		(cond ((or (>= (setf tem (+ y2 dy2)) ylim)
			   (minusp tem))
		       (setf dy2 (- dy2))))
		(setf x1 (+ x1 dx1)
		      y1 (+ y1 dy1)
		      x2 (+ x2 dx2)
		      y2 (+ y2 dy2))
		
		finally (loop repeat length
			      when (caar history)
			      do
			      ;1; QuickDraw commands*
			      (tb:!moveto (first (car history)) (second (car history)))
			      (tb:!lineto (third (car history)) (fourth (car history)))
			      
			      do (setf history (cdr history)))))))

